﻿<%@ Page Title="Patients" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="Patients.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.Patients" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
     <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
    </style>
       
</asp:Content> 

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type="text/javascript">
        function PopUpMessage(objMsg) {
            if (confirm(objMsg)) {
                document.getElementById('<%= HiddenFieldEfrPatients.ClientID %>').value = "false";
                document.getElementById('<%= ButtonSearchPatient.ClientID %>').click();
                return true;
            }
            else {
                return false;
            }
        }
    </script>

    <asp:ValidationSummary ID="ValidationSummaryPatients" runat="server"  
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
  
     <asp:Panel ID="PanelObjectContent" runat="server">
        <br />
        <asp:Panel ID="PanelSelectPatient" runat="server" GroupingText="&nbsp;&nbsp;Lookup Patient&nbsp;&nbsp;" Width="100%">

            <br />

            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSSNSearch" runat="server" AssociatedControlID="TextBoxPatientSSNSearch">SSN:
            </asp:Label>

            <br />

            <asp:TextBox ID="TextBoxPatientSSNSearch" runat="server" 
                TabIndex="2" 
                Width = "350px">
            </asp:TextBox>
            <asp:RegularExpressionValidator ID="SSNValidator" runat="server" 
                TabIndex="3" 
                ControlToValidate="TextBoxPatientSSNSearch" 
                Display="Dynamic" 
                ErrorMessage="* Invalid SSN"
                SetFocusOnError="true" 
                ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
            </asp:RegularExpressionValidator>     
                
            <br /><br />

            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientFirstNameSearch" runat="server" AssociatedControlID="TextBoxPatientFirstNameSearch">First Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientFirstNameSearch" runat="server" Width = "350px"></asp:TextBox>
            <br /><br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientLastNameSearch" runat="server" AssociatedControlID="TextBoxPatientLastNameSearch">Last Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientLastNameSearch" runat="server" Width = "350px"></asp:TextBox>
            <br /><br />
            <asp:Label SkinID="DataLabel" ID="LabelforTextBoxPatientICNSearch" runat="server" AssociatedControlID="TextBoxPatientICNSearch">ICN:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientICNSearch" runat="server" Width = "350px"></asp:TextBox>
            <br />
            <br />
            <asp:Button ID="ButtonSearchPatient" runat="server" Text="&nbsp;&nbsp;Search&nbsp;&nbsp;" 
                onclick="ButtonSearchPatient_Click" />
            <br /><br />

            <asp:GridView ID="GridViewEFRPatients" runat="server" Visible="False" DataKeyNames="PATIENT_ID" AutoGenerateColumns="False" 
                Width="100%" AllowPaging="True" AllowSorting="True" DataSourceID = "ObjectDataSourcePatientsSearch" OnRowCommand = "Patients_RowCommand" 
                CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">

                <EmptyDataTemplate>
                    No EFR patients found matching your search criteria
                </EmptyDataTemplate> 

                <Columns>
                    <asp:BoundField DataField="PATIENT_SSN" HeaderText="SSN" SortExpression="SSN" >
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:BoundField>

                    <asp:BoundField DataField="PATIENT_FULL_NAME" HeaderText="Full Name" SortExpression="LAST_NAME" >
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:BoundField>

                    <asp:TemplateField HeaderText="Site Number" SortExpression="STATIONNUMBER">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STATION_NUMBER"))) %>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                     <asp:TemplateField HeaderText="Facility" SortExpression="VISTANAME">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FACILITY"))) %>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="City" SortExpression="CITY">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelCity" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PATIENT_ADDRESS_CITY")))%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:ButtonField 
                        HeaderText="Patient Information" 
                        ButtonType = "Button" 
                        Text = "Patient Information" 
                        CommandName = "Details" 
                        AccessibleHeaderText = "Select" 
                        ControlStyle-Width="130px" 
                        ItemStyle-Width = "130px"/>
                
                    <asp:ButtonField 
                        HeaderText="Workflows" 
                        ButtonType = "Button" 
                        Text = "Workflows" 
                        CommandName = "Workflows" 
                        AccessibleHeaderText = "Workflows" 
                        ControlStyle-Width="80px" 
                        ItemStyle-Width = "80px" />
            
                    <asp:TemplateField HeaderText="Related Diagnoses">
                        <ItemTemplate>
                            <asp:Button 
                                ID = "buttonDiagnostics"  
                                runat = "server" 
                                UseSubmitBehavior="false" 
                                Text = "Related Diagnoses" 
                                CommandArgument = '<%# Container.DataItemIndex %>' 
                                CommandName = "Diagnostics" 
                                ToolTip = '<%# GetButtonToolTip(Eval("DIAGNOSTIC_TESTS_COUNT"), "Diagnostic Tests") %>'
                                Enabled = '<%# (int)Eval("DIAGNOSTIC_TESTS_COUNT") > 0  %>' />   
                        </ItemTemplate>
                    </asp:TemplateField> 
 
                     <asp:TemplateField HeaderText="Lab Tests">
                        <ItemTemplate>
                            <asp:Button 
                                ID = "buttonLabTests"  
                                runat = "server" 
                                UseSubmitBehavior="false" 
                                Text = "Lab Tests"  
                                CommandName = "LabTests" 
                                CommandArgument = '<%# Container.DataItemIndex %>' 
                                ToolTip = '<%# GetButtonToolTip(Eval("RELATED_LAB_TESTS_COUNT"), "Related Lab Tests") %>'
                                Enabled = '<%# (int)Eval("RELATED_LAB_TESTS_COUNT") > 0  %>' />   
                        </ItemTemplate>
                    </asp:TemplateField> 

                    <asp:TemplateField HeaderText="Images">
                        <ItemTemplate>
                            <asp:Button 
                                ID = "buttonImages"  
                                runat = "server" 
                                UseSubmitBehavior="false" 
                                Text = "Images" 
                                AccessibleHeaderText = "Images" 
                                CommandArgument = '<%# Container.DataItemIndex %>' 
                                CommandName = "Images" 
                                ToolTip = '<%# GetButtonToolTip(Eval("IMAGES_COUNT"), "Images") %>'
                                Enabled = '<%# (int)Eval("IMAGES_COUNT") > 0  %>' />   
                        </ItemTemplate>
                    </asp:TemplateField> 
                </Columns>
           </asp:GridView>

           <asp:GridView ID="GridViewNonEfrPatients" runat="server" Visible="False" DataKeyNames="PATIENT_ID" 
                 AutoGenerateColumns="False" Width="100%" AllowPaging="True" AllowSorting="True" 
                 DataSourceID = "ObjectDataSourceNonEfrPatientsSearch" OnRowCommand = "NonEfrPatients_RowCommand" 
                 CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
                
               <EmptyDataTemplate>
                    This patient does not exist in either the EFR or Registries database.  Please contact the system administrator.
                </EmptyDataTemplate> 
                
               <Columns>
                    <asp:BoundField DataField="PATIENT_SSN" HeaderText="SSN" SortExpression="SSN" >
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:BoundField>

                    <asp:BoundField DataField="PATIENT_FULL_NAME" HeaderText="Full Name" SortExpression="LAST_NAME" >
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:BoundField>

                    <asp:TemplateField HeaderText="Site Number" SortExpression="STATIONNUMBER">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("STATION_NUMBER"))) %>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                     <asp:TemplateField HeaderText="Facility" SortExpression="VISTANAME">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FACILITY"))) %>'>
                            </asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="City" SortExpression="CITY">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID="LabelCity" runat="server" 
                                Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PATIENT_ADDRESS_CITY")))%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:ButtonField ButtonType="Button" Text="Create Referral" CommandName="AddReferral" 
                        AccessibleHeaderText="Select" ControlStyle-Width="120px" ItemStyle-Width="120px"/>
                </Columns>
            </asp:GridView>

           <br />

            <asp:ObjectDataSource ID="ObjectDataSourcePatientsSearch" runat="server" 
                SelectMethod="SearchPatients" 
                SelectCountMethod="SearchPatientsCount" 
                StartRowIndexParameterName="START_ROW" 
                MaximumRowsParameterName="MAX_ROWS" 
                SortParameterName="SORT_COLUMN"
                EnablePaging="True"   
                TypeName="VIRP.EFR.BLL.PatientManager">               
                <SelectParameters>
                    <asp:Parameter Name="CURRENT_USER" Type="String" />
                    <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                    <asp:ControlParameter ControlID="TextBoxPatientICNSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_ICN" Type="String"/>
                    <asp:ControlParameter ControlID="TextBoxPatientSSNSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_SSN" Type="String"/> 
                    <asp:ControlParameter ControlID="TextBoxPatientLastNameSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_LAST_NAME" Type="String"/>  
                    <asp:ControlParameter ControlID="TextBoxPatientFirstNameSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_FIRST_NAME" Type="String"/> 
                    <asp:Parameter Name="SORT_COLUMN" Type="String" />
                    <asp:Parameter Name="START_ROW" Type="Int32" />
                    <asp:Parameter Name="MAX_ROWS" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>

            <asp:ObjectDataSource ID="ObjectDataSourceNonEfrPatientsSearch" runat="server" 
                SelectMethod="SearchAllPatients" 
                SelectCountMethod="SearchAllPatientsCount" 
                StartRowIndexParameterName="START_ROW" 
                MaximumRowsParameterName="MAX_ROWS" 
                SortParameterName="SORT_COLUMN"
                EnablePaging="True"   
                TypeName="VIRP.EFR.BLL.PatientManager">               
                <SelectParameters>
                    <asp:Parameter Name="CURRENT_USER" Type="String" />
                    <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                    <asp:ControlParameter ControlID="TextBoxPatientICNSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_ICN" Type="String"/>
                    <asp:ControlParameter ControlID="TextBoxPatientSSNSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_SSN" Type="String"/> 
                    <asp:ControlParameter ControlID="TextBoxPatientLastNameSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_LAST_NAME" Type="String"/>  
                    <asp:ControlParameter ControlID="TextBoxPatientFirstNameSearch" ConvertEmptyStringToNull = "true"  Direction="Input" Name="PATIENT_FIRST_NAME" Type="String"/> 
                    <asp:Parameter Name="SORT_COLUMN" Type="String" />
                    <asp:Parameter Name="START_ROW" Type="Int32" />
                    <asp:Parameter Name="MAX_ROWS" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>

        </asp:Panel>
    </asp:Panel> 
    <asp:HiddenField runat="server" ID="HiddenFieldEfrPatients" Value="true" />
</asp:Content> 